---
title: Blip-2 API Usage Guide
createdAt: Thu Jul 18 2024 06:12:37 GMT+0000 (Coordinated Universal Time)
updatedAt: Thu Jul 18 2024 13:40:04 GMT+0000 (Coordinated Universal Time)
---

# Blip-2 API Usage Guide

## Introduction

This document will guide developers on how to use the aonweb library to call the Blip-2 API, Answers questions about images.

## Prerequisites

- Node.js environment
- `aonweb` library installed
- Valid Aonet APPID

## Basic Usage

### 1. Import Required Modules

```js
import { AI, AIOptions } from 'aonweb';
```

### 2. Initialize AI Instance

```js
const ai_options = new AIOptions({
    appId: 'your_app_id_here',
    dev_mode: true
});

const aonweb = new AI(ai_options);
```

### 3. Prepare Input Data Example

```js
const data = {
   input:{
      "image": "https://replicate.delivery/pbxt/IJDXbkPoG6rXgFJ08ZhuQHCnX4t62zceE2hgriK8yv3vXEBw/merlion_demo.png",
      "question": "What is this a picture of?",
      "temperature": 1
    }
};
```

```js
const data = {
   input:{
      "image": "https://replicate.delivery/pbxt/IJEPJQ1Cx2l0TVdISAtGBATLGr0bn3sqZfOAY05QXepqDXd5/gg_bridge.jpeg",
      "caption": true,
      "temperature": 1
    }
};
```

```js
const data = {
   input:{
      "image": "https://replicate.delivery/pbxt/IJEPmgAlL2zNBNDoRRKFegTEcxnlRhoQxlNjPHSZEy0pSIKn/gg_bridge.jpeg",
      "caption": false,
      "question": "what body of water does this bridge cross?",
      "temperature": 1
    }
};
```

```js
const data = {
   input:{
      "image": "https://replicate.delivery/pbxt/IJETATwaW4ZAi1I86Xx5H0LjD4f4NBVcMvbSbUxCnPBKFQsE/panda.jpeg",
      "context": "question: what animal is this? answer: panda",
      "question": "what country is this animal from? ",
      "temperature": 1
    }
};
```

### 4. Call the AI Model

```js
const price = 8; // Cost of the AI call
try {
    const response = await aonweb.prediction("/predictions/ai/blip-2@andreasjansson", data, price);
    // Handle response
    console.log("Blip-2 result:", response);
} catch (error) {
    // Error handling
    console.error("Error generating :", error);
}
```

### Parameter Description

- `image`: String, Input image to query or caption.
- `caption`: Boolean, Select if you want to generate image captions instead of asking questions.
- `context`: String,Optional - previous questions and answers to be used as context for answering current question.
- `question`: String, Question to ask about this image. Leave blank for captioning.
- `temperature`: Number, Temperature for use with nucleus sampling.

### Notes

- Ensure that the provided image URL is publicly accessible and of good quality to achieve the best recognition results.
- The API may take some time to process the input and generate the result, consider implementing appropriate wait or loading states.
- Handle possible errors, such as network issues, invalid input, or API limitations.
- Adhere to the terms of use and privacy regulations, especially when handling image samples of others.

### Example Response

The API response will contain the results of the image recognition or other relevant information. Parse and use the response data according to the actual API documentation.
